﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;

namespace WPF.PresentationLayer.Resources.Validators
{
    public class BooleanValidatorAttribute : RequiredAttribute
    {
        public bool ExpectedValue { get; private set; }

        public BooleanValidatorAttribute(string errorMessage) : this(errorMessage, true) { }

        public BooleanValidatorAttribute(string errorMessage, bool expectedValue)
        {
            ErrorMessage = errorMessage;
            ExpectedValue = expectedValue;
        }

        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            if (validationContext == null) throw new ArgumentNullException("validationContext");

            return (bool)value == ExpectedValue ? null : new ValidationResult(ErrorMessage);
        }
    }
}
